# Generated by Django 5.2.6 on 2025-09-28 01:00

import django.db.models.deletion
from decimal import Decimal
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('condominio', '0002_aviso'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Regla',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('codigo', models.CharField(help_text="Un código único para la regla, ej: 'RESTRICCION_DEUDA_MANTENIMIENTO'", max_length=50, unique=True)),
                ('titulo', models.CharField(max_length=255)),
                ('descripcion', models.TextField(help_text='La explicación detallada de la regla.')),
                ('categoria', models.CharField(choices=[('FINANZAS', 'Finanzas'), ('SEGURIDAD', 'Seguridad'), ('MANTENIMIENTO', 'Mantenimiento'), ('GENERAL', 'General')], default='GENERAL', max_length=50)),
                ('activa', models.BooleanField(default=True, help_text='Desmarcar para ocultar la regla sin borrarla.')),
            ],
            options={
                'verbose_name': 'Regla del Condominio',
                'verbose_name_plural': 'Reglas del Condominio',
                'ordering': ['categoria', 'titulo'],
            },
        ),
        migrations.CreateModel(
            name='Reserva',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('fecha_reserva', models.DateField()),
                ('hora_inicio', models.TimeField()),
                ('hora_fin', models.TimeField()),
                ('costo', models.DecimalField(decimal_places=2, default=Decimal('0.00'), max_digits=10)),
                ('estado', models.CharField(choices=[('SOLICITADA', 'Solicitada'), ('CONFIRMADA', 'Confirmada'), ('PAGADA', 'Pagada'), ('CANCELADA', 'Cancelada')], default='SOLICITADA', max_length=20)),
                ('creado_en', models.DateTimeField(auto_now_add=True)),
                ('area_comun', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='condominio.areacomun')),
                ('usuario', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
